/* File: mfixsolvermodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Wed May 15 17:00:07 2019
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *mfixsolver_error;
static PyObject *mfixsolver_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef signed char signed_char;
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#define pyobj_from_double1(v) (PyFloat_FromDouble(v))
#define PRINTPYOBJERR(obj)\
    fprintf(stderr,"mfixsolver.error is related to ");\
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");

#define pyobj_from_int1(v) (PyInt_FromLong(v))
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

/* New SciPy */
#define TRYPYARRAYTEMPLATECHAR case NPY_STRING: *(char *)(PyArray_DATA(arr))=*v; break;
#define TRYPYARRAYTEMPLATELONG case NPY_LONG: *(long *)(PyArray_DATA(arr))=*v; break;
#define TRYPYARRAYTEMPLATEOBJECT case NPY_OBJECT: PyArray_SETITEM(arr,PyArray_DATA(arr),pyobj_from_ ## ctype ## 1(*v)); break;

#define TRYPYARRAYTEMPLATE(ctype,typecode) \
        PyArrayObject *arr = NULL;\
        if (!obj) return -2;\
        if (!PyArray_Check(obj)) return -1;\
        if (!(arr=(PyArrayObject *)obj)) {fprintf(stderr,"TRYPYARRAYTEMPLATE:");PRINTPYOBJERR(obj);return 0;}\
        if (PyArray_DESCR(arr)->type==typecode)  {*(ctype *)(PyArray_DATA(arr))=*v; return 1;}\
        switch (PyArray_TYPE(arr)) {\
                case NPY_DOUBLE: *(double *)(PyArray_DATA(arr))=*v; break;\
                case NPY_INT: *(int *)(PyArray_DATA(arr))=*v; break;\
                case NPY_LONG: *(long *)(PyArray_DATA(arr))=*v; break;\
                case NPY_FLOAT: *(float *)(PyArray_DATA(arr))=*v; break;\
                case NPY_CDOUBLE: *(double *)(PyArray_DATA(arr))=*v; break;\
                case NPY_CFLOAT: *(float *)(PyArray_DATA(arr))=*v; break;\
                case NPY_BOOL: *(npy_bool *)(PyArray_DATA(arr))=(*v!=0); break;\
                case NPY_UBYTE: *(unsigned char *)(PyArray_DATA(arr))=*v; break;\
                case NPY_BYTE: *(signed char *)(PyArray_DATA(arr))=*v; break;\
                case NPY_SHORT: *(short *)(PyArray_DATA(arr))=*v; break;\
                case NPY_USHORT: *(npy_ushort *)(PyArray_DATA(arr))=*v; break;\
                case NPY_UINT: *(npy_uint *)(PyArray_DATA(arr))=*v; break;\
                case NPY_ULONG: *(npy_ulong *)(PyArray_DATA(arr))=*v; break;\
                case NPY_LONGLONG: *(npy_longlong *)(PyArray_DATA(arr))=*v; break;\
                case NPY_ULONGLONG: *(npy_ulonglong *)(PyArray_DATA(arr))=*v; break;\
                case NPY_LONGDOUBLE: *(npy_longdouble *)(PyArray_DATA(arr))=*v; break;\
                case NPY_CLONGDOUBLE: *(npy_longdouble *)(PyArray_DATA(arr))=*v; break;\
                case NPY_OBJECT: PyArray_SETITEM(arr, PyArray_DATA(arr), pyobj_from_ ## ctype ## 1(*v)); break;\
        default: return -2;\
        };\
        return 1

#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = mfixsolver_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
#if PY_VERSION_HEX >= 0x03000000
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
#else
    else {
        tmp = PyObject_Str(obj);
    }
#endif
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = mfixsolver_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int try_pyarr_from_int(PyObject* obj,int* v) {
    TRYPYARRAYTEMPLATE(int,'i');
}

static int try_pyarr_from_double(PyObject* obj,double* v) {
    TRYPYARRAYTEMPLATE(double,'d');
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = mfixsolver_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************************* mfix_exit *********************************/
static char doc_f2py_rout_mfixsolver_exit_mfix_exit[] = "\
mfix_exit(myid,[normal_termination])\n\nWrapper for ``mfix_exit``.\
\n\nParameters\n----------\n"
"myid : input int\n"
"\nOther Parameters\n----------------\n"
"normal_termination : input int";
/*  */
static PyObject *f2py_rout_mfixsolver_exit_mfix_exit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int myid = 0;
  PyObject *myid_capi = Py_None;
  int normal_termination = 0;
  PyObject *normal_termination_capi = Py_None;
  static char *capi_kwlist[] = {"myid","normal_termination",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|O:mfixsolver.exit.mfix_exit",\
    capi_kwlist,&myid_capi,&normal_termination_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable myid */
    f2py_success = int_from_pyobj(&myid,myid_capi,"mfixsolver.exit.mfix_exit() 1st argument (myid) can't be converted to int");
  if (f2py_success) {
  /* Processing variable normal_termination */
  if (normal_termination_capi != Py_None)
    normal_termination = (int)PyObject_IsTrue(normal_termination_capi);
    f2py_success = 1;
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&myid,&normal_termination);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of normal_termination*/
  /* End of cleaning variable normal_termination */
  } /*if (f2py_success) of myid*/
  /* End of cleaning variable myid */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of mfix_exit ******************************/

/****************************** check_exit_flag ******************************/
static char doc_f2py_rout_mfixsolver_exit_check_exit_flag[] = "\
check_exit_flag = check_exit_flag()\n\nWrapper for ``check_exit_flag``.\
\n\nReturns\n-------\n"
"check_exit_flag : int";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_exit_check_exit_flag(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int check_exit_flag = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.exit.check_exit_flag",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable check_exit_flag */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&check_exit_flag);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",check_exit_flag);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable check_exit_flag */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*************************** end of check_exit_flag ***************************/

/********************************* close_file *********************************/
static char doc_f2py_rout_mfixsolver_exit_close_file[] = "\
close_file(unit_l)\n\nWrapper for ``close_file``.\
\n\nParameters\n----------\n"
"unit_l : input int";
/*  */
static PyObject *f2py_rout_mfixsolver_exit_close_file(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int unit_l = 0;
  PyObject *unit_l_capi = Py_None;
  static char *capi_kwlist[] = {"unit_l",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.exit.close_file",\
    capi_kwlist,&unit_l_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable unit_l */
    f2py_success = int_from_pyobj(&unit_l,unit_l_capi,"mfixsolver.exit.close_file() 1st argument (unit_l) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&unit_l);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of unit_l*/
  /* End of cleaning variable unit_l */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of close_file *****************************/

/******************************** iterate_init ********************************/
static char doc_f2py_rout_mfixsolver_iterate_iterate_init[] = "\
iterate_init()\n\nWrapper for ``iterate_init``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_iterate_iterate_init(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.iterate.iterate_init",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of iterate_init ****************************/

/******************************** do_iteration ********************************/
static char doc_f2py_rout_mfixsolver_iterate_do_iteration[] = "\
do_iteration(mfix_dat)\n\nWrapper for ``do_iteration``.\
\n\nParameters\n----------\n"
"mfix_dat : input string(len=-1)";
/*  */
static PyObject *f2py_rout_mfixsolver_iterate_do_iteration(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string mfix_dat = NULL;
  int slen(mfix_dat);
  PyObject *mfix_dat_capi = Py_None;
  static char *capi_kwlist[] = {"mfix_dat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.iterate.do_iteration",\
    capi_kwlist,&mfix_dat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mfix_dat */
  slen(mfix_dat) = -1;
  f2py_success = string_from_pyobj(&mfix_dat,&slen(mfix_dat),"",mfix_dat_capi,"string_from_pyobj failed in converting 1st argument `mfix_dat' of mfixsolver.iterate.do_iteration to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(mfix_dat,slen(mfix_dat));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(mfix_dat);
  }  /*if (f2py_success) of mfix_dat*/
  /* End of cleaning variable mfix_dat */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of do_iteration ****************************/

/******************************** post_iterate ********************************/
static char doc_f2py_rout_mfixsolver_iterate_post_iterate[] = "\
post_iterate()\n\nWrapper for ``post_iterate``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_iterate_post_iterate(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.iterate.post_iterate",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of post_iterate ****************************/

/******************************** log_diverged ********************************/
static char doc_f2py_rout_mfixsolver_iterate_log_diverged[] = "\
log_diverged()\n\nWrapper for ``log_diverged``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_iterate_log_diverged(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.iterate.log_diverged",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of log_diverged ****************************/

/******************************* log_converged *******************************/
static char doc_f2py_rout_mfixsolver_iterate_log_converged[] = "\
log_converged()\n\nWrapper for ``log_converged``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_iterate_log_converged(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.iterate.log_converged",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of log_converged ****************************/

/****************************** goalseekmassflux ******************************/
static char doc_f2py_rout_mfixsolver_iterate_goalseekmassflux[] = "\
goalseekmassflux(nit,mustit,doit)\n\nWrapper for ``goalseekmassflux``.\
\n\nParameters\n----------\n"
"nit : in/output rank-0 array(int,'i')\n"
"mustit : in/output rank-0 array(int,'i')\n"
"doit : input int";
/*  */
static PyObject *f2py_rout_mfixsolver_iterate_goalseekmassflux(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nit = 0;
  PyObject *nit_capi = Py_None;
  int mustit = 0;
  PyObject *mustit_capi = Py_None;
  int doit = 0;
  PyObject *doit_capi = Py_None;
  static char *capi_kwlist[] = {"nit","mustit","doit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO:mfixsolver.iterate.goalseekmassflux",\
    capi_kwlist,&nit_capi,&mustit_capi,&doit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nit */
    f2py_success = int_from_pyobj(&nit,nit_capi,"mfixsolver.iterate.goalseekmassflux() 1st argument (nit) can't be converted to int");
  if (f2py_success) {
  /* Processing variable mustit */
    f2py_success = int_from_pyobj(&mustit,mustit_capi,"mfixsolver.iterate.goalseekmassflux() 2nd argument (mustit) can't be converted to int");
  if (f2py_success) {
  /* Processing variable doit */
    doit = (int)PyObject_IsTrue(doit_capi);
    f2py_success = 1;
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nit,&mustit,&doit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
  f2py_success = try_pyarr_from_int(nit_capi,&nit);
  if (f2py_success) {
  f2py_success = try_pyarr_from_int(mustit_capi,&mustit);
  if (f2py_success) {
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
  } /*if (f2py_success) of mustit pyobjfrom*/
  } /*if (f2py_success) of nit pyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of doit*/
  /* End of cleaning variable doit */
  } /*if (f2py_success) of mustit*/
  /* End of cleaning variable mustit */
  } /*if (f2py_success) of nit*/
  /* End of cleaning variable nit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of goalseekmassflux **************************/

/********************************** adjustdt **********************************/
static char doc_f2py_rout_mfixsolver_iterate_adjustdt[] = "\
adjustdt = adjustdt(mfix_dat)\n\nWrapper for ``adjustdt``.\
\n\nParameters\n----------\n"
"mfix_dat : input string(len=-1)\n"
"\nReturns\n-------\n"
"adjustdt : int";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_iterate_adjustdt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int adjustdt = 0;
  string mfix_dat = NULL;
  int slen(mfix_dat);
  PyObject *mfix_dat_capi = Py_None;
  static char *capi_kwlist[] = {"mfix_dat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.iterate.adjustdt",\
    capi_kwlist,&mfix_dat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable adjustdt */
  /* Processing variable mfix_dat */
  slen(mfix_dat) = -1;
  f2py_success = string_from_pyobj(&mfix_dat,&slen(mfix_dat),"",mfix_dat_capi,"string_from_pyobj failed in converting 1st argument `mfix_dat' of mfixsolver.iterate.adjustdt to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&adjustdt,mfix_dat,slen(mfix_dat));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",adjustdt);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(mfix_dat);
  }  /*if (f2py_success) of mfix_dat*/
  /* End of cleaning variable mfix_dat */
  /* End of cleaning variable adjustdt */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of adjustdt ******************************/

/********************************* get_run_id *********************************/
static char doc_f2py_rout_mfixsolver_machine_get_run_id[] = "\
get_run_id()\n\nWrapper for ``get_run_id``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_machine_get_run_id(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.machine.get_run_id",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of get_run_id *****************************/

/********************************* start_log *********************************/
static char doc_f2py_rout_mfixsolver_machine_start_log[] = "\
start_log()\n\nWrapper for ``start_log``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_machine_start_log(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.machine.start_log",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of start_log ******************************/

/********************************** end_log **********************************/
static char doc_f2py_rout_mfixsolver_machine_end_log[] = "\
end_log()\n\nWrapper for ``end_log``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_machine_end_log(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.machine.end_log",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of end_log *******************************/

/********************************* run_mfix0 *********************************/
static char doc_f2py_rout_mfixsolver_main_run_mfix0[] = "\
run_mfix0(mfix_dat_filename,cmdline_loglevel)\n\nWrapper for ``run_mfix0``.\
\n\nParameters\n----------\n"
"mfix_dat_filename : input string(len=1000)\n"
"cmdline_loglevel : input int";
/*  */
static PyObject *f2py_rout_mfixsolver_main_run_mfix0(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string mfix_dat_filename = NULL;
  int slen(mfix_dat_filename);
  PyObject *mfix_dat_filename_capi = Py_None;
  int cmdline_loglevel = 0;
  PyObject *cmdline_loglevel_capi = Py_None;
  static char *capi_kwlist[] = {"mfix_dat_filename","cmdline_loglevel",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:mfixsolver.main.run_mfix0",\
    capi_kwlist,&mfix_dat_filename_capi,&cmdline_loglevel_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mfix_dat_filename */
  slen(mfix_dat_filename) = 1000;
  f2py_success = string_from_pyobj(&mfix_dat_filename,&slen(mfix_dat_filename),"",mfix_dat_filename_capi,"string_from_pyobj failed in converting 1st argument `mfix_dat_filename' of mfixsolver.main.run_mfix0 to C string");
  if (f2py_success) {
  /* Processing variable cmdline_loglevel */
    f2py_success = int_from_pyobj(&cmdline_loglevel,cmdline_loglevel_capi,"mfixsolver.main.run_mfix0() 2nd argument (cmdline_loglevel) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
      Py_BEGIN_ALLOW_THREADS
        (*f2py_func)(mfix_dat_filename,&cmdline_loglevel,slen(mfix_dat_filename));
      Py_END_ALLOW_THREADS
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of cmdline_loglevel*/
  /* End of cleaning variable cmdline_loglevel */
    STRINGFREE(mfix_dat_filename);
  }  /*if (f2py_success) of mfix_dat_filename*/
  /* End of cleaning variable mfix_dat_filename */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of run_mfix0 ******************************/

/********************************* initialize *********************************/
static char doc_f2py_rout_mfixsolver_main_initialize[] = "\
initialize(mfix_dat)\n\nWrapper for ``initialize``.\
\n\nParameters\n----------\n"
"mfix_dat : input string(len=-1)";
/*  */
static PyObject *f2py_rout_mfixsolver_main_initialize(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string mfix_dat = NULL;
  int slen(mfix_dat);
  PyObject *mfix_dat_capi = Py_None;
  static char *capi_kwlist[] = {"mfix_dat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.main.initialize",\
    capi_kwlist,&mfix_dat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mfix_dat */
  slen(mfix_dat) = -1;
  f2py_success = string_from_pyobj(&mfix_dat,&slen(mfix_dat),"",mfix_dat_capi,"string_from_pyobj failed in converting 1st argument `mfix_dat' of mfixsolver.main.initialize to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(mfix_dat,slen(mfix_dat));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(mfix_dat);
  }  /*if (f2py_success) of mfix_dat*/
  /* End of cleaning variable mfix_dat */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of initialize *****************************/

/********************************** get_data **********************************/
static char doc_f2py_rout_mfixsolver_main_get_data[] = "\
get_data(mfix_dat)\n\nWrapper for ``get_data``.\
\n\nParameters\n----------\n"
"mfix_dat : input string(len=-1)";
/*  */
static PyObject *f2py_rout_mfixsolver_main_get_data(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string mfix_dat = NULL;
  int slen(mfix_dat);
  PyObject *mfix_dat_capi = Py_None;
  static char *capi_kwlist[] = {"mfix_dat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.main.get_data",\
    capi_kwlist,&mfix_dat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mfix_dat */
  slen(mfix_dat) = -1;
  f2py_success = string_from_pyobj(&mfix_dat,&slen(mfix_dat),"",mfix_dat_capi,"string_from_pyobj failed in converting 1st argument `mfix_dat' of mfixsolver.main.get_data to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(mfix_dat,slen(mfix_dat));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(mfix_dat);
  }  /*if (f2py_success) of mfix_dat*/
  /* End of cleaning variable mfix_dat */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of get_data ******************************/

/********************************* check_data *********************************/
static char doc_f2py_rout_mfixsolver_main_check_data[] = "\
check_data(mfix_dat)\n\nWrapper for ``check_data``.\
\n\nParameters\n----------\n"
"mfix_dat : input string(len=-1)";
/*  */
static PyObject *f2py_rout_mfixsolver_main_check_data(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string mfix_dat = NULL;
  int slen(mfix_dat);
  PyObject *mfix_dat_capi = Py_None;
  static char *capi_kwlist[] = {"mfix_dat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.main.check_data",\
    capi_kwlist,&mfix_dat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mfix_dat */
  slen(mfix_dat) = -1;
  f2py_success = string_from_pyobj(&mfix_dat,&slen(mfix_dat),"",mfix_dat_capi,"string_from_pyobj failed in converting 1st argument `mfix_dat' of mfixsolver.main.check_data to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(mfix_dat,slen(mfix_dat));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(mfix_dat);
  }  /*if (f2py_success) of mfix_dat*/
  /* End of cleaning variable mfix_dat */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of check_data *****************************/

/********************************** finalize **********************************/
static char doc_f2py_rout_mfixsolver_main_finalize[] = "\
finalize()\n\nWrapper for ``finalize``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_main_finalize(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.main.finalize",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of finalize ******************************/

/************************** add_command_line_keyword **************************/
static char doc_f2py_rout_mfixsolver_main_add_command_line_keyword[] = "\
add_command_line_keyword(arg)\n\nWrapper for ``add_command_line_keyword``.\
\n\nParameters\n----------\n"
"arg : input string(len=-1)";
/*  */
static PyObject *f2py_rout_mfixsolver_main_add_command_line_keyword(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string arg = NULL;
  int slen(arg);
  PyObject *arg_capi = Py_None;
  static char *capi_kwlist[] = {"arg",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.main.add_command_line_keyword",\
    capi_kwlist,&arg_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable arg */
  slen(arg) = -1;
  f2py_success = string_from_pyobj(&arg,&slen(arg),"",arg_capi,"string_from_pyobj failed in converting 1st argument `arg' of mfixsolver.main.add_command_line_keyword to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(arg,slen(arg));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(arg);
  }  /*if (f2py_success) of arg*/
  /* End of cleaning variable arg */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************** end of add_command_line_keyword **********************/

/******************************** print_flags ********************************/
static char doc_f2py_rout_mfixsolver_main_print_flags[] = "\
print_flags()\n\nWrapper for ``print_flags``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_main_print_flags(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.main.print_flags",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of print_flags *****************************/

/******************************* parallel_init *******************************/
static char doc_f2py_rout_mfixsolver_parallel_mpi_parallel_init[] = "\
parallel_init()\n\nWrapper for ``parallel_init``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_parallel_mpi_parallel_init(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.parallel_mpi.parallel_init",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of parallel_init ****************************/

/******************************** parallel_fin ********************************/
static char doc_f2py_rout_mfixsolver_parallel_mpi_parallel_fin[] = "\
parallel_fin()\n\nWrapper for ``parallel_fin``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_parallel_mpi_parallel_fin(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.parallel_mpi.parallel_fin",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of parallel_fin ****************************/

/********************************* mpi_check *********************************/
static char doc_f2py_rout_mfixsolver_parallel_mpi_mpi_check[] = "\
mpi_check(msg,ierr)\n\nWrapper for ``mpi_check``.\
\n\nParameters\n----------\n"
"msg : input string(len=-1)\n"
"ierr : input int";
/*  */
static PyObject *f2py_rout_mfixsolver_parallel_mpi_mpi_check(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string msg = NULL;
  int slen(msg);
  PyObject *msg_capi = Py_None;
  int ierr = 0;
  PyObject *ierr_capi = Py_None;
  static char *capi_kwlist[] = {"msg","ierr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:mfixsolver.parallel_mpi.mpi_check",\
    capi_kwlist,&msg_capi,&ierr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable msg */
  slen(msg) = -1;
  f2py_success = string_from_pyobj(&msg,&slen(msg),"",msg_capi,"string_from_pyobj failed in converting 1st argument `msg' of mfixsolver.parallel_mpi.mpi_check to C string");
  if (f2py_success) {
  /* Processing variable ierr */
    f2py_success = int_from_pyobj(&ierr,ierr_capi,"mfixsolver.parallel_mpi.mpi_check() 2nd argument (ierr) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(msg,&ierr,slen(msg));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ierr*/
  /* End of cleaning variable ierr */
    STRINGFREE(msg);
  }  /*if (f2py_success) of msg*/
  /* End of cleaning variable msg */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of mpi_check ******************************/

/*********************************** filler ***********************************/
static char doc_f2py_rout_mfixsolver_param_filler[] = "\
filler()\n\nWrapper for ``filler``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_param_filler(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.param.filler",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of filler *******************************/

/***************************** wait_while_paused *****************************/
static char doc_f2py_rout_mfixsolver_pause_wait_while_paused[] = "\
wait_while_paused()\n\nWrapper for ``wait_while_paused``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_pause_wait_while_paused(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.pause.wait_while_paused",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of wait_while_paused **************************/

/***************************** paused_flag_bcast *****************************/
static char doc_f2py_rout_mfixsolver_pause_paused_flag_bcast[] = "\
paused_flag_bcast = paused_flag_bcast()\n\nWrapper for ``paused_flag_bcast``.\
\n\nReturns\n-------\n"
"paused_flag_bcast : int";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_pause_paused_flag_bcast(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int paused_flag_bcast = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.pause.paused_flag_bcast",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable paused_flag_bcast */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&paused_flag_bcast);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",paused_flag_bcast);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable paused_flag_bcast */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of paused_flag_bcast **************************/

/***************************** check_reinit_flag *****************************/
static char doc_f2py_rout_mfixsolver_pause_check_reinit_flag[] = "\
check_reinit_flag = check_reinit_flag()\n\nWrapper for ``check_reinit_flag``.\
\n\nReturns\n-------\n"
"check_reinit_flag : int";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_pause_check_reinit_flag(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int check_reinit_flag = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.pause.check_reinit_flag",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable check_reinit_flag */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&check_reinit_flag);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",check_reinit_flag);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable check_reinit_flag */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of check_reinit_flag **************************/

/****************************** set_reinit_data ******************************/
static char doc_f2py_rout_mfixsolver_pause_set_reinit_data[] = "\
set_reinit_data(mfix_dat)\n\nWrapper for ``set_reinit_data``.\
\n\nParameters\n----------\n"
"mfix_dat : input string(len=-1)";
/*  */
static PyObject *f2py_rout_mfixsolver_pause_set_reinit_data(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string mfix_dat = NULL;
  int slen(mfix_dat);
  PyObject *mfix_dat_capi = Py_None;
  static char *capi_kwlist[] = {"mfix_dat",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.pause.set_reinit_data",\
    capi_kwlist,&mfix_dat_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable mfix_dat */
  slen(mfix_dat) = -1;
  f2py_success = string_from_pyobj(&mfix_dat,&slen(mfix_dat),"",mfix_dat_capi,"string_from_pyobj failed in converting 1st argument `mfix_dat' of mfixsolver.pause.set_reinit_data to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(mfix_dat,slen(mfix_dat));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(mfix_dat);
  }  /*if (f2py_success) of mfix_dat*/
  /* End of cleaning variable mfix_dat */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*************************** end of set_reinit_data ***************************/

/********************************* do_reinit *********************************/
static char doc_f2py_rout_mfixsolver_pause_do_reinit[] = "\
do_reinit()\n\nWrapper for ``do_reinit``.\
\n";
/*  */
static PyObject *f2py_rout_mfixsolver_pause_do_reinit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.pause.do_reinit",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of do_reinit ******************************/

/*********************************** usleep ***********************************/
static char doc_f2py_rout_mfixsolver_pause_usleep[] = "\
usleep(useconds)\n\nWrapper for ``usleep``.\
\n\nParameters\n----------\n"
"useconds : input int";
/*  */
static PyObject *f2py_rout_mfixsolver_pause_usleep(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int useconds = 0;
  PyObject *useconds_capi = Py_None;
  static char *capi_kwlist[] = {"useconds",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.pause.usleep",\
    capi_kwlist,&useconds_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable useconds */
    f2py_success = int_from_pyobj(&useconds,useconds_capi,"mfixsolver.pause.usleep() 1st argument (useconds) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&useconds);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of useconds*/
  /* End of cleaning variable useconds */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of usleep *******************************/

/*************************** get_resid_string_count ***************************/
static char doc_f2py_rout_mfixsolver_residual_pub_get_resid_string_count[] = "\
get_resid_string_count = get_resid_string_count()\n\nWrapper for ``get_resid_string_count``.\
\n\nReturns\n-------\n"
"get_resid_string_count : int";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_residual_pub_get_resid_string_count(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int get_resid_string_count = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.residual_pub.get_resid_string_count",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable get_resid_string_count */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&get_resid_string_count);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",get_resid_string_count);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable get_resid_string_count */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*********************** end of get_resid_string_count ***********************/

/****************************** get_resid_string ******************************/
static char doc_f2py_rout_mfixsolver_residual_pub_get_resid_string[] = "\
get_resid_string = get_resid_string(index_bn)\n\nWrapper for ``get_resid_string``.\
\n\nParameters\n----------\n"
"index_bn : input int\n"
"\nReturns\n-------\n"
"get_resid_string : string(len=4)";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_residual_pub_get_resid_string(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string get_resid_string = NULL;
  int slen(get_resid_string);
  PyObject *get_resid_string_capi = Py_None;
  int index_bn = 0;
  PyObject *index_bn_capi = Py_None;
  static char *capi_kwlist[] = {"index_bn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.residual_pub.get_resid_string",\
    capi_kwlist,&index_bn_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable get_resid_string */
  slen(get_resid_string) = 4;
  f2py_success = string_from_pyobj(&get_resid_string,&slen(get_resid_string),"",get_resid_string_capi,"string_from_pyobj failed in converting hidden `get_resid_string' of mfixsolver.residual_pub.get_resid_string to C string");
  if (f2py_success) {
  /* Processing variable index_bn */
    f2py_success = int_from_pyobj(&index_bn,index_bn_capi,"mfixsolver.residual_pub.get_resid_string() 1st argument (index_bn) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(get_resid_string,&index_bn,slen(get_resid_string));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("y",get_resid_string);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of index_bn*/
  /* End of cleaning variable index_bn */
    STRINGFREE(get_resid_string);
  }  /*if (f2py_success) of get_resid_string*/
  /* End of cleaning variable get_resid_string */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of get_resid_string **************************/

/************************* get_resid_grp_string_count *************************/
static char doc_f2py_rout_mfixsolver_residual_pub_get_resid_grp_string_count[] = "\
get_resid_grp_string_count = get_resid_grp_string_count()\n\nWrapper for ``get_resid_grp_string_count``.\
\n\nReturns\n-------\n"
"get_resid_grp_string_count : int";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_residual_pub_get_resid_grp_string_count(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int get_resid_grp_string_count = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.residual_pub.get_resid_grp_string_count",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable get_resid_grp_string_count */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&get_resid_grp_string_count);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",get_resid_grp_string_count);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable get_resid_grp_string_count */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************* end of get_resid_grp_string_count *********************/

/**************************** get_resid_grp_string ****************************/
static char doc_f2py_rout_mfixsolver_residual_pub_get_resid_grp_string[] = "\
get_resid_grp_string = get_resid_grp_string(index_bn)\n\nWrapper for ``get_resid_grp_string``.\
\n\nParameters\n----------\n"
"index_bn : input int\n"
"\nReturns\n-------\n"
"get_resid_grp_string : string(len=8)";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_residual_pub_get_resid_grp_string(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string get_resid_grp_string = NULL;
  int slen(get_resid_grp_string);
  PyObject *get_resid_grp_string_capi = Py_None;
  int index_bn = 0;
  PyObject *index_bn_capi = Py_None;
  static char *capi_kwlist[] = {"index_bn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.residual_pub.get_resid_grp_string",\
    capi_kwlist,&index_bn_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable get_resid_grp_string */
  slen(get_resid_grp_string) = 8;
  f2py_success = string_from_pyobj(&get_resid_grp_string,&slen(get_resid_grp_string),"",get_resid_grp_string_capi,"string_from_pyobj failed in converting hidden `get_resid_grp_string' of mfixsolver.residual_pub.get_resid_grp_string to C string");
  if (f2py_success) {
  /* Processing variable index_bn */
    f2py_success = int_from_pyobj(&index_bn,index_bn_capi,"mfixsolver.residual_pub.get_resid_grp_string() 1st argument (index_bn) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(get_resid_grp_string,&index_bn,slen(get_resid_grp_string));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("y",get_resid_grp_string);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of index_bn*/
  /* End of cleaning variable index_bn */
    STRINGFREE(get_resid_grp_string);
  }  /*if (f2py_success) of get_resid_grp_string*/
  /* End of cleaning variable get_resid_grp_string */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************ end of get_resid_grp_string ************************/

/********************************* get_resid *********************************/
static char doc_f2py_rout_mfixsolver_residual_pub_get_resid[] = "\
get_resid = get_resid(index_bn)\n\nWrapper for ``get_resid``.\
\n\nParameters\n----------\n"
"index_bn : input int\n"
"\nReturns\n-------\n"
"get_resid : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_residual_pub_get_resid(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double get_resid = 0;
  int index_bn = 0;
  PyObject *index_bn_capi = Py_None;
  static char *capi_kwlist[] = {"index_bn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.residual_pub.get_resid",\
    capi_kwlist,&index_bn_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable get_resid */
  /* Processing variable index_bn */
    f2py_success = int_from_pyobj(&index_bn,index_bn_capi,"mfixsolver.residual_pub.get_resid() 1st argument (index_bn) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&get_resid,&index_bn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",get_resid);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of index_bn*/
  /* End of cleaning variable index_bn */
  /* End of cleaning variable get_resid */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of get_resid ******************************/

/******************************* get_resid_grp *******************************/
static char doc_f2py_rout_mfixsolver_residual_pub_get_resid_grp[] = "\
get_resid_grp = get_resid_grp(index_bn)\n\nWrapper for ``get_resid_grp``.\
\n\nParameters\n----------\n"
"index_bn : input int\n"
"\nReturns\n-------\n"
"get_resid_grp : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_residual_pub_get_resid_grp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double get_resid_grp = 0;
  int index_bn = 0;
  PyObject *index_bn_capi = Py_None;
  static char *capi_kwlist[] = {"index_bn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:mfixsolver.residual_pub.get_resid_grp",\
    capi_kwlist,&index_bn_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable get_resid_grp */
  /* Processing variable index_bn */
    f2py_success = int_from_pyobj(&index_bn,index_bn_capi,"mfixsolver.residual_pub.get_resid_grp() 1st argument (index_bn) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&get_resid_grp,&index_bn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",get_resid_grp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of index_bn*/
  /* End of cleaning variable index_bn */
  /* End of cleaning variable get_resid_grp */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of get_resid_grp ****************************/

/********************************* get_tunit *********************************/
static char doc_f2py_rout_mfixsolver_run_get_tunit[] = "\
get_tunit(tleft,tunit)\n\nWrapper for ``get_tunit``.\
\n\nParameters\n----------\n"
"tleft : in/output rank-0 array(float,'d')\n"
"tunit : input string(len=4)";
/*  */
static PyObject *f2py_rout_mfixsolver_run_get_tunit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double tleft = 0;
  PyObject *tleft_capi = Py_None;
  string tunit = NULL;
  int slen(tunit);
  PyObject *tunit_capi = Py_None;
  static char *capi_kwlist[] = {"tleft","tunit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:mfixsolver.run.get_tunit",\
    capi_kwlist,&tleft_capi,&tunit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable tleft */
    f2py_success = double_from_pyobj(&tleft,tleft_capi,"mfixsolver.run.get_tunit() 1st argument (tleft) can't be converted to double");
  if (f2py_success) {
  /* Processing variable tunit */
  slen(tunit) = 4;
  f2py_success = string_from_pyobj(&tunit,&slen(tunit),"",tunit_capi,"string_from_pyobj failed in converting 2nd argument `tunit' of mfixsolver.run.get_tunit to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&tleft,tunit,slen(tunit));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
  f2py_success = try_pyarr_from_double(tleft_capi,&tleft);
  if (f2py_success) {
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
  } /*if (f2py_success) of tleft pyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(tunit);
  }  /*if (f2py_success) of tunit*/
  /* End of cleaning variable tunit */
  } /*if (f2py_success) of tleft*/
  /* End of cleaning variable tleft */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of get_tunit ******************************/

/********************************* wall_time *********************************/
static char doc_f2py_rout_mfixsolver_time_cpu_wall_time[] = "\
wall_time = wall_time()\n\nWrapper for ``wall_time``.\
\n\nReturns\n-------\n"
"wall_time : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_mfixsolver_time_cpu_wall_time(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double wall_time = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":mfixsolver.time_cpu.wall_time",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable wall_time */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&wall_time);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",wall_time);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable wall_time */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of wall_time ******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_compar_def[] = {
  {"mype",0,{{-1}},NPY_INT},
  {"numpes",0,{{-1}},NPY_INT},
  {"mpierr",0,{{-1}},NPY_INT},
  {"pe_io",0,{{-1}},NPY_INT},
  {"nodesi",0,{{-1}},NPY_INT},
  {"nodesj",0,{{-1}},NPY_INT},
  {"nodesk",0,{{-1}},NPY_INT},
  {"dlb_nodesi",1,{{100}},NPY_INT},
  {"dlb_nodesj",1,{{100}},NPY_INT},
  {"dlb_nodesk",1,{{100}},NPY_INT},
  {"root",0,{{-1}},NPY_INT},
  {"nlayers_bicgs",0,{{-1}},NPY_INT},
  {"ijkstart3_all",1,{{-1}},NPY_INT},
  {"ijkend3_all",1,{{-1}},NPY_INT},
  {"istart_all",1,{{-1}},NPY_INT},
  {"istart1_all",1,{{-1}},NPY_INT},
  {"istart2_all",1,{{-1}},NPY_INT},
  {"istart3_all",1,{{-1}},NPY_INT},
  {"jstart_all",1,{{-1}},NPY_INT},
  {"jstart1_all",1,{{-1}},NPY_INT},
  {"jstart2_all",1,{{-1}},NPY_INT},
  {"jstart3_all",1,{{-1}},NPY_INT},
  {"kstart_all",1,{{-1}},NPY_INT},
  {"kstart1_all",1,{{-1}},NPY_INT},
  {"kstart2_all",1,{{-1}},NPY_INT},
  {"kstart3_all",1,{{-1}},NPY_INT},
  {"iend_all",1,{{-1}},NPY_INT},
  {"iend1_all",1,{{-1}},NPY_INT},
  {"iend2_all",1,{{-1}},NPY_INT},
  {"iend3_all",1,{{-1}},NPY_INT},
  {"jend_all",1,{{-1}},NPY_INT},
  {"jend1_all",1,{{-1}},NPY_INT},
  {"jend2_all",1,{{-1}},NPY_INT},
  {"jend3_all",1,{{-1}},NPY_INT},
  {"kend_all",1,{{-1}},NPY_INT},
  {"kend1_all",1,{{-1}},NPY_INT},
  {"kend2_all",1,{{-1}},NPY_INT},
  {"kend3_all",1,{{-1}},NPY_INT},
  {"ijksize3_all",1,{{-1}},NPY_INT},
  {"displs",1,{{-1}},NPY_INT},
  {"imap",1,{{-1}},NPY_INT},
  {"jmap",1,{{-1}},NPY_INT},
  {"kmap",1,{{-1}},NPY_INT},
  {"imap_c",1,{{-1}},NPY_INT},
  {"jmap_c",1,{{-1}},NPY_INT},
  {"kmap_c",1,{{-1}},NPY_INT},
  {"ijksize3",0,{{-1}},NPY_INT},
  {"ijkstart3",0,{{-1}},NPY_INT},
  {"ijkend3",0,{{-1}},NPY_INT},
  {"istart3",0,{{-1}},NPY_INT},
  {"iend3",0,{{-1}},NPY_INT},
  {"jstart3",0,{{-1}},NPY_INT},
  {"jend3",0,{{-1}},NPY_INT},
  {"kstart3",0,{{-1}},NPY_INT},
  {"kend3",0,{{-1}},NPY_INT},
  {"istart2",0,{{-1}},NPY_INT},
  {"iend2",0,{{-1}},NPY_INT},
  {"jstart2",0,{{-1}},NPY_INT},
  {"jend2",0,{{-1}},NPY_INT},
  {"kstart2",0,{{-1}},NPY_INT},
  {"kend2",0,{{-1}},NPY_INT},
  {"istart1",0,{{-1}},NPY_INT},
  {"iend1",0,{{-1}},NPY_INT},
  {"jstart1",0,{{-1}},NPY_INT},
  {"jend1",0,{{-1}},NPY_INT},
  {"kstart1",0,{{-1}},NPY_INT},
  {"kend1",0,{{-1}},NPY_INT},
  {"istart",0,{{-1}},NPY_INT},
  {"iend",0,{{-1}},NPY_INT},
  {"jstart",0,{{-1}},NPY_INT},
  {"jend",0,{{-1}},NPY_INT},
  {"kstart",0,{{-1}},NPY_INT},
  {"kend",0,{{-1}},NPY_INT},
  {"fbname",1,{{5}},NPY_STRING},
  {"idbg",0,{{-1}},NPY_INT},
  {"c0",0,{{-1}},NPY_INT},
  {"c1",0,{{-1}},NPY_INT},
  {"c2",0,{{-1}},NPY_INT},
  {"ijk_array_of",3,{{-1,-1,-1}},NPY_INT},
  {"funijk_map_c",3,{{-1,-1,-1}},NPY_INT},
  {"west_array_of",1,{{-1}},NPY_INT},
  {"east_array_of",1,{{-1}},NPY_INT},
  {"south_array_of",1,{{-1}},NPY_INT},
  {"north_array_of",1,{{-1}},NPY_INT},
  {"bottom_array_of",1,{{-1}},NPY_INT},
  {"top_array_of",1,{{-1}},NPY_INT},
  {"im_array_of",1,{{-1}},NPY_INT},
  {"ip_array_of",1,{{-1}},NPY_INT},
  {"jm_array_of",1,{{-1}},NPY_INT},
  {"jp_array_of",1,{{-1}},NPY_INT},
  {"km_array_of",1,{{-1}},NPY_INT},
  {"kp_array_of",1,{{-1}},NPY_INT},
  {"dead_cell_at",3,{{-1,-1,-1}},NPY_INT},
  {"increment_arrays_allocated",0,{{-1}},NPY_INT},
  {"ngc_east",0,{{-1}},NPY_INT},
  {"ngc_west",0,{{-1}},NPY_INT},
  {"ngc_north",0,{{-1}},NPY_INT},
  {"ngc_south",0,{{-1}},NPY_INT},
  {"ngc_top",0,{{-1}},NPY_INT},
  {"ngc_bottom",0,{{-1}},NPY_INT},
  {"lgc_east",1,{{-1}},NPY_INT},
  {"lgc_west",1,{{-1}},NPY_INT},
  {"lgc_north",1,{{-1}},NPY_INT},
  {"lgc_south",1,{{-1}},NPY_INT},
  {"lgc_top",1,{{-1}},NPY_INT},
  {"lgc_bottom",1,{{-1}},NPY_INT},
  {"isize_all",1,{{-1}},NPY_INT},
  {"jsize_all",1,{{-1}},NPY_INT},
  {"ksize_all",1,{{-1}},NPY_INT},
  {"domain_size_adjusted",0,{{-1}},NPY_INT},
  {"ncpp_uniform",1,{{-1}},NPY_INT},
  {"ncpp_uniform_backed_up",0,{{-1}},NPY_INT},
  {"new_ijksize3_all",1,{{-1}},NPY_INT},
  {"short_gridmap_init",0,{{-1}},NPY_INT},
  {"adjust_partition",0,{{-1}},NPY_INT},
  {NULL}
};

static void f2py_setup_compar(char *mype,char *numpes,char *mpierr,char *pe_io,char *nodesi,char *nodesj,char *nodesk,char *dlb_nodesi,char *dlb_nodesj,char *dlb_nodesk,char *root,char *nlayers_bicgs,void (*ijkstart3_all)(int*,int*,void(*)(char*,int*),int*),void (*ijkend3_all)(int*,int*,void(*)(char*,int*),int*),void (*istart_all)(int*,int*,void(*)(char*,int*),int*),void (*istart1_all)(int*,int*,void(*)(char*,int*),int*),void (*istart2_all)(int*,int*,void(*)(char*,int*),int*),void (*istart3_all)(int*,int*,void(*)(char*,int*),int*),void (*jstart_all)(int*,int*,void(*)(char*,int*),int*),void (*jstart1_all)(int*,int*,void(*)(char*,int*),int*),void (*jstart2_all)(int*,int*,void(*)(char*,int*),int*),void (*jstart3_all)(int*,int*,void(*)(char*,int*),int*),void (*kstart_all)(int*,int*,void(*)(char*,int*),int*),void (*kstart1_all)(int*,int*,void(*)(char*,int*),int*),void (*kstart2_all)(int*,int*,void(*)(char*,int*),int*),void (*kstart3_all)(int*,int*,void(*)(char*,int*),int*),void (*iend_all)(int*,int*,void(*)(char*,int*),int*),void (*iend1_all)(int*,int*,void(*)(char*,int*),int*),void (*iend2_all)(int*,int*,void(*)(char*,int*),int*),void (*iend3_all)(int*,int*,void(*)(char*,int*),int*),void (*jend_all)(int*,int*,void(*)(char*,int*),int*),void (*jend1_all)(int*,int*,void(*)(char*,int*),int*),void (*jend2_all)(int*,int*,void(*)(char*,int*),int*),void (*jend3_all)(int*,int*,void(*)(char*,int*),int*),void (*kend_all)(int*,int*,void(*)(char*,int*),int*),void (*kend1_all)(int*,int*,void(*)(char*,int*),int*),void (*kend2_all)(int*,int*,void(*)(char*,int*),int*),void (*kend3_all)(int*,int*,void(*)(char*,int*),int*),void (*ijksize3_all)(int*,int*,void(*)(char*,int*),int*),void (*displs)(int*,int*,void(*)(char*,int*),int*),void (*imap)(int*,int*,void(*)(char*,int*),int*),void (*jmap)(int*,int*,void(*)(char*,int*),int*),void (*kmap)(int*,int*,void(*)(char*,int*),int*),void (*imap_c)(int*,int*,void(*)(char*,int*),int*),void (*jmap_c)(int*,int*,void(*)(char*,int*),int*),void (*kmap_c)(int*,int*,void(*)(char*,int*),int*),char *ijksize3,char *ijkstart3,char *ijkend3,char *istart3,char *iend3,char *jstart3,char *jend3,char *kstart3,char *kend3,char *istart2,char *iend2,char *jstart2,char *jend2,char *kstart2,char *kend2,char *istart1,char *iend1,char *jstart1,char *jend1,char *kstart1,char *kend1,char *istart,char *iend,char *jstart,char *jend,char *kstart,char *kend,char *fbname,char *idbg,char *c0,char *c1,char *c2,void (*ijk_array_of)(int*,int*,void(*)(char*,int*),int*),void (*funijk_map_c)(int*,int*,void(*)(char*,int*),int*),void (*west_array_of)(int*,int*,void(*)(char*,int*),int*),void (*east_array_of)(int*,int*,void(*)(char*,int*),int*),void (*south_array_of)(int*,int*,void(*)(char*,int*),int*),void (*north_array_of)(int*,int*,void(*)(char*,int*),int*),void (*bottom_array_of)(int*,int*,void(*)(char*,int*),int*),void (*top_array_of)(int*,int*,void(*)(char*,int*),int*),void (*im_array_of)(int*,int*,void(*)(char*,int*),int*),void (*ip_array_of)(int*,int*,void(*)(char*,int*),int*),void (*jm_array_of)(int*,int*,void(*)(char*,int*),int*),void (*jp_array_of)(int*,int*,void(*)(char*,int*),int*),void (*km_array_of)(int*,int*,void(*)(char*,int*),int*),void (*kp_array_of)(int*,int*,void(*)(char*,int*),int*),void (*dead_cell_at)(int*,int*,void(*)(char*,int*),int*),char *increment_arrays_allocated,char *ngc_east,char *ngc_west,char *ngc_north,char *ngc_south,char *ngc_top,char *ngc_bottom,void (*lgc_east)(int*,int*,void(*)(char*,int*),int*),void (*lgc_west)(int*,int*,void(*)(char*,int*),int*),void (*lgc_north)(int*,int*,void(*)(char*,int*),int*),void (*lgc_south)(int*,int*,void(*)(char*,int*),int*),void (*lgc_top)(int*,int*,void(*)(char*,int*),int*),void (*lgc_bottom)(int*,int*,void(*)(char*,int*),int*),void (*isize_all)(int*,int*,void(*)(char*,int*),int*),void (*jsize_all)(int*,int*,void(*)(char*,int*),int*),void (*ksize_all)(int*,int*,void(*)(char*,int*),int*),char *domain_size_adjusted,void (*ncpp_uniform)(int*,int*,void(*)(char*,int*),int*),char *ncpp_uniform_backed_up,void (*new_ijksize3_all)(int*,int*,void(*)(char*,int*),int*),char *short_gridmap_init,char *adjust_partition) {
  int i_f2py=0;
  f2py_compar_def[i_f2py++].data = mype;
  f2py_compar_def[i_f2py++].data = numpes;
  f2py_compar_def[i_f2py++].data = mpierr;
  f2py_compar_def[i_f2py++].data = pe_io;
  f2py_compar_def[i_f2py++].data = nodesi;
  f2py_compar_def[i_f2py++].data = nodesj;
  f2py_compar_def[i_f2py++].data = nodesk;
  f2py_compar_def[i_f2py++].data = dlb_nodesi;
  f2py_compar_def[i_f2py++].data = dlb_nodesj;
  f2py_compar_def[i_f2py++].data = dlb_nodesk;
  f2py_compar_def[i_f2py++].data = root;
  f2py_compar_def[i_f2py++].data = nlayers_bicgs;
  f2py_compar_def[i_f2py++].func = ijkstart3_all;
  f2py_compar_def[i_f2py++].func = ijkend3_all;
  f2py_compar_def[i_f2py++].func = istart_all;
  f2py_compar_def[i_f2py++].func = istart1_all;
  f2py_compar_def[i_f2py++].func = istart2_all;
  f2py_compar_def[i_f2py++].func = istart3_all;
  f2py_compar_def[i_f2py++].func = jstart_all;
  f2py_compar_def[i_f2py++].func = jstart1_all;
  f2py_compar_def[i_f2py++].func = jstart2_all;
  f2py_compar_def[i_f2py++].func = jstart3_all;
  f2py_compar_def[i_f2py++].func = kstart_all;
  f2py_compar_def[i_f2py++].func = kstart1_all;
  f2py_compar_def[i_f2py++].func = kstart2_all;
  f2py_compar_def[i_f2py++].func = kstart3_all;
  f2py_compar_def[i_f2py++].func = iend_all;
  f2py_compar_def[i_f2py++].func = iend1_all;
  f2py_compar_def[i_f2py++].func = iend2_all;
  f2py_compar_def[i_f2py++].func = iend3_all;
  f2py_compar_def[i_f2py++].func = jend_all;
  f2py_compar_def[i_f2py++].func = jend1_all;
  f2py_compar_def[i_f2py++].func = jend2_all;
  f2py_compar_def[i_f2py++].func = jend3_all;
  f2py_compar_def[i_f2py++].func = kend_all;
  f2py_compar_def[i_f2py++].func = kend1_all;
  f2py_compar_def[i_f2py++].func = kend2_all;
  f2py_compar_def[i_f2py++].func = kend3_all;
  f2py_compar_def[i_f2py++].func = ijksize3_all;
  f2py_compar_def[i_f2py++].func = displs;
  f2py_compar_def[i_f2py++].func = imap;
  f2py_compar_def[i_f2py++].func = jmap;
  f2py_compar_def[i_f2py++].func = kmap;
  f2py_compar_def[i_f2py++].func = imap_c;
  f2py_compar_def[i_f2py++].func = jmap_c;
  f2py_compar_def[i_f2py++].func = kmap_c;
  f2py_compar_def[i_f2py++].data = ijksize3;
  f2py_compar_def[i_f2py++].data = ijkstart3;
  f2py_compar_def[i_f2py++].data = ijkend3;
  f2py_compar_def[i_f2py++].data = istart3;
  f2py_compar_def[i_f2py++].data = iend3;
  f2py_compar_def[i_f2py++].data = jstart3;
  f2py_compar_def[i_f2py++].data = jend3;
  f2py_compar_def[i_f2py++].data = kstart3;
  f2py_compar_def[i_f2py++].data = kend3;
  f2py_compar_def[i_f2py++].data = istart2;
  f2py_compar_def[i_f2py++].data = iend2;
  f2py_compar_def[i_f2py++].data = jstart2;
  f2py_compar_def[i_f2py++].data = jend2;
  f2py_compar_def[i_f2py++].data = kstart2;
  f2py_compar_def[i_f2py++].data = kend2;
  f2py_compar_def[i_f2py++].data = istart1;
  f2py_compar_def[i_f2py++].data = iend1;
  f2py_compar_def[i_f2py++].data = jstart1;
  f2py_compar_def[i_f2py++].data = jend1;
  f2py_compar_def[i_f2py++].data = kstart1;
  f2py_compar_def[i_f2py++].data = kend1;
  f2py_compar_def[i_f2py++].data = istart;
  f2py_compar_def[i_f2py++].data = iend;
  f2py_compar_def[i_f2py++].data = jstart;
  f2py_compar_def[i_f2py++].data = jend;
  f2py_compar_def[i_f2py++].data = kstart;
  f2py_compar_def[i_f2py++].data = kend;
  f2py_compar_def[i_f2py++].data = fbname;
  f2py_compar_def[i_f2py++].data = idbg;
  f2py_compar_def[i_f2py++].data = c0;
  f2py_compar_def[i_f2py++].data = c1;
  f2py_compar_def[i_f2py++].data = c2;
  f2py_compar_def[i_f2py++].func = ijk_array_of;
  f2py_compar_def[i_f2py++].func = funijk_map_c;
  f2py_compar_def[i_f2py++].func = west_array_of;
  f2py_compar_def[i_f2py++].func = east_array_of;
  f2py_compar_def[i_f2py++].func = south_array_of;
  f2py_compar_def[i_f2py++].func = north_array_of;
  f2py_compar_def[i_f2py++].func = bottom_array_of;
  f2py_compar_def[i_f2py++].func = top_array_of;
  f2py_compar_def[i_f2py++].func = im_array_of;
  f2py_compar_def[i_f2py++].func = ip_array_of;
  f2py_compar_def[i_f2py++].func = jm_array_of;
  f2py_compar_def[i_f2py++].func = jp_array_of;
  f2py_compar_def[i_f2py++].func = km_array_of;
  f2py_compar_def[i_f2py++].func = kp_array_of;
  f2py_compar_def[i_f2py++].func = dead_cell_at;
  f2py_compar_def[i_f2py++].data = increment_arrays_allocated;
  f2py_compar_def[i_f2py++].data = ngc_east;
  f2py_compar_def[i_f2py++].data = ngc_west;
  f2py_compar_def[i_f2py++].data = ngc_north;
  f2py_compar_def[i_f2py++].data = ngc_south;
  f2py_compar_def[i_f2py++].data = ngc_top;
  f2py_compar_def[i_f2py++].data = ngc_bottom;
  f2py_compar_def[i_f2py++].func = lgc_east;
  f2py_compar_def[i_f2py++].func = lgc_west;
  f2py_compar_def[i_f2py++].func = lgc_north;
  f2py_compar_def[i_f2py++].func = lgc_south;
  f2py_compar_def[i_f2py++].func = lgc_top;
  f2py_compar_def[i_f2py++].func = lgc_bottom;
  f2py_compar_def[i_f2py++].func = isize_all;
  f2py_compar_def[i_f2py++].func = jsize_all;
  f2py_compar_def[i_f2py++].func = ksize_all;
  f2py_compar_def[i_f2py++].data = domain_size_adjusted;
  f2py_compar_def[i_f2py++].func = ncpp_uniform;
  f2py_compar_def[i_f2py++].data = ncpp_uniform_backed_up;
  f2py_compar_def[i_f2py++].func = new_ijksize3_all;
  f2py_compar_def[i_f2py++].data = short_gridmap_init;
  f2py_compar_def[i_f2py++].data = adjust_partition;
}
extern void F_FUNC(f2pyinitcompar,F2PYINITCOMPAR)(void (*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),char*,char*,char*,char*,char*,char*,char*,void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),void (*)(int*,int*,void(*)(char*,int*),int*),char*,void (*)(int*,int*,void(*)(char*,int*),int*),char*,void (*)(int*,int*,void(*)(char*,int*),int*),char*,char*));
static void f2py_init_compar(void) {
  F_FUNC(f2pyinitcompar,F2PYINITCOMPAR)(f2py_setup_compar);
}


static FortranDataDef f2py_exit_def[] = {
  {"exit_flag",0,{{-1}},NPY_INT},
  {"mfix_exit",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_exit_mfix_exit,doc_f2py_rout_mfixsolver_exit_mfix_exit},
  {"check_exit_flag",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_exit_check_exit_flag,doc_f2py_rout_mfixsolver_exit_check_exit_flag},
  {"close_file",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_exit_close_file,doc_f2py_rout_mfixsolver_exit_close_file},
  {NULL}
};

static void f2py_setup_exit(char *exit_flag,char *mfix_exit,char *check_exit_flag,char *close_file) {
  int i_f2py=0;
  f2py_exit_def[i_f2py++].data = exit_flag;
  f2py_exit_def[i_f2py++].data = mfix_exit;
  f2py_exit_def[i_f2py++].data = check_exit_flag;
  f2py_exit_def[i_f2py++].data = close_file;
}
extern void F_FUNC(f2pyinitexit,F2PYINITEXIT)(void (*)(char*,char *,char *,char *));
static void f2py_init_exit(void) {
  F_FUNC(f2pyinitexit,F2PYINITEXIT)(f2py_setup_exit);
}


static FortranDataDef f2py_iterate_def[] = {
  {"mustit",0,{{-1}},NPY_INT},
  {"nit",0,{{-1}},NPY_INT},
  {"max_nit",0,{{-1}},NPY_INT},
  {"converged",0,{{-1}},NPY_INT},
  {"diverged",0,{{-1}},NPY_INT},
  {"tleft",0,{{-1}},NPY_DOUBLE},
  {"normg",0,{{-1}},NPY_DOUBLE},
  {"norms",0,{{-1}},NPY_DOUBLE},
  {"setg",0,{{-1}},NPY_INT},
  {"sets",0,{{-1}},NPY_INT},
  {"resg",0,{{-1}},NPY_DOUBLE},
  {"ress",0,{{-1}},NPY_DOUBLE},
  {"smass",0,{{-1}},NPY_DOUBLE},
  {"errorpercent",1,{{-1}},NPY_DOUBLE},
  {"lmsg",1,{{32}},NPY_STRING},
  {"call_solve_pp_g",0,{{-1}},NPY_INT},
  {"iterate_init",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_iterate_iterate_init,doc_f2py_rout_mfixsolver_iterate_iterate_init},
  {"do_iteration",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_iterate_do_iteration,doc_f2py_rout_mfixsolver_iterate_do_iteration},
  {"post_iterate",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_iterate_post_iterate,doc_f2py_rout_mfixsolver_iterate_post_iterate},
  {"log_diverged",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_iterate_log_diverged,doc_f2py_rout_mfixsolver_iterate_log_diverged},
  {"log_converged",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_iterate_log_converged,doc_f2py_rout_mfixsolver_iterate_log_converged},
  {"goalseekmassflux",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_iterate_goalseekmassflux,doc_f2py_rout_mfixsolver_iterate_goalseekmassflux},
  {"adjustdt",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_iterate_adjustdt,doc_f2py_rout_mfixsolver_iterate_adjustdt},
  {NULL}
};

static void f2py_setup_iterate(char *mustit,char *nit,char *max_nit,char *converged,char *diverged,char *tleft,char *normg,char *norms,char *setg,char *sets,char *resg,char *ress,char *smass,void (*errorpercent)(int*,int*,void(*)(char*,int*),int*),char *lmsg,char *call_solve_pp_g,char *iterate_init,char *do_iteration,char *post_iterate,char *log_diverged,char *log_converged,char *goalseekmassflux,char *adjustdt) {
  int i_f2py=0;
  f2py_iterate_def[i_f2py++].data = mustit;
  f2py_iterate_def[i_f2py++].data = nit;
  f2py_iterate_def[i_f2py++].data = max_nit;
  f2py_iterate_def[i_f2py++].data = converged;
  f2py_iterate_def[i_f2py++].data = diverged;
  f2py_iterate_def[i_f2py++].data = tleft;
  f2py_iterate_def[i_f2py++].data = normg;
  f2py_iterate_def[i_f2py++].data = norms;
  f2py_iterate_def[i_f2py++].data = setg;
  f2py_iterate_def[i_f2py++].data = sets;
  f2py_iterate_def[i_f2py++].data = resg;
  f2py_iterate_def[i_f2py++].data = ress;
  f2py_iterate_def[i_f2py++].data = smass;
  f2py_iterate_def[i_f2py++].func = errorpercent;
  f2py_iterate_def[i_f2py++].data = lmsg;
  f2py_iterate_def[i_f2py++].data = call_solve_pp_g;
  f2py_iterate_def[i_f2py++].data = iterate_init;
  f2py_iterate_def[i_f2py++].data = do_iteration;
  f2py_iterate_def[i_f2py++].data = post_iterate;
  f2py_iterate_def[i_f2py++].data = log_diverged;
  f2py_iterate_def[i_f2py++].data = log_converged;
  f2py_iterate_def[i_f2py++].data = goalseekmassflux;
  f2py_iterate_def[i_f2py++].data = adjustdt;
}
extern void F_FUNC(f2pyinititerate,F2PYINITITERATE)(void (*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,void (*)(int*,int*,void(*)(char*,int*),int*),char*,char*,char *,char *,char *,char *,char *,char *,char *));
static void f2py_init_iterate(void) {
  F_FUNC(f2pyinititerate,F2PYINITITERATE)(f2py_setup_iterate);
}


static FortranDataDef f2py_machine_def[] = {
  {"open_n1",0,{{-1}},NPY_INT},
  {"nwords_dp",0,{{-1}},NPY_INT},
  {"nwords_r",0,{{-1}},NPY_INT},
  {"nwords_i",0,{{-1}},NPY_INT},
  {"id_node",1,{{64}},NPY_STRING},
  {"id_month",0,{{-1}},NPY_INT},
  {"id_day",0,{{-1}},NPY_INT},
  {"id_year",0,{{-1}},NPY_INT},
  {"id_hour",0,{{-1}},NPY_INT},
  {"id_minute",0,{{-1}},NPY_INT},
  {"id_second",0,{{-1}},NPY_INT},
  {"get_run_id",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_machine_get_run_id,doc_f2py_rout_mfixsolver_machine_get_run_id},
  {"start_log",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_machine_start_log,doc_f2py_rout_mfixsolver_machine_start_log},
  {"end_log",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_machine_end_log,doc_f2py_rout_mfixsolver_machine_end_log},
  {NULL}
};

static void f2py_setup_machine(char *open_n1,char *nwords_dp,char *nwords_r,char *nwords_i,char *id_node,char *id_month,char *id_day,char *id_year,char *id_hour,char *id_minute,char *id_second,char *get_run_id,char *start_log,char *end_log) {
  int i_f2py=0;
  f2py_machine_def[i_f2py++].data = open_n1;
  f2py_machine_def[i_f2py++].data = nwords_dp;
  f2py_machine_def[i_f2py++].data = nwords_r;
  f2py_machine_def[i_f2py++].data = nwords_i;
  f2py_machine_def[i_f2py++].data = id_node;
  f2py_machine_def[i_f2py++].data = id_month;
  f2py_machine_def[i_f2py++].data = id_day;
  f2py_machine_def[i_f2py++].data = id_year;
  f2py_machine_def[i_f2py++].data = id_hour;
  f2py_machine_def[i_f2py++].data = id_minute;
  f2py_machine_def[i_f2py++].data = id_second;
  f2py_machine_def[i_f2py++].data = get_run_id;
  f2py_machine_def[i_f2py++].data = start_log;
  f2py_machine_def[i_f2py++].data = end_log;
}
extern void F_FUNC(f2pyinitmachine,F2PYINITMACHINE)(void (*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char *,char *,char *));
static void f2py_init_machine(void) {
  F_FUNC(f2pyinitmachine,F2PYINITMACHINE)(f2py_setup_machine);
}


static FortranDataDef f2py_main_def[] = {
  {"cpu1",0,{{-1}},NPY_DOUBLE},
  {"cputime_used",0,{{-1}},NPY_DOUBLE},
  {"walltime_used",0,{{-1}},NPY_DOUBLE},
  {"version",1,{{512}},NPY_STRING},
  {"nit_total",0,{{-1}},NPY_INT},
  {"ncheck",0,{{-1}},NPY_INT},
  {"dncheck",0,{{-1}},NPY_INT},
  {"cmd_line_args",1,{{100,80}},NPY_STRING},
  {"cmd_line_args_count",0,{{-1}},NPY_INT},
  {"run_mfix0",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_main_run_mfix0,doc_f2py_rout_mfixsolver_main_run_mfix0},
  {"initialize",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_main_initialize,doc_f2py_rout_mfixsolver_main_initialize},
  {"get_data",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_main_get_data,doc_f2py_rout_mfixsolver_main_get_data},
  {"check_data",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_main_check_data,doc_f2py_rout_mfixsolver_main_check_data},
  {"finalize",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_main_finalize,doc_f2py_rout_mfixsolver_main_finalize},
  {"add_command_line_keyword",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_main_add_command_line_keyword,doc_f2py_rout_mfixsolver_main_add_command_line_keyword},
  {"print_flags",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_main_print_flags,doc_f2py_rout_mfixsolver_main_print_flags},
  {NULL}
};

static void f2py_setup_main(char *cpu1,char *cputime_used,char *walltime_used,char *version,char *nit_total,char *ncheck,char *dncheck,char *cmd_line_args,char *cmd_line_args_count,char *run_mfix0,char *initialize,char *get_data,char *check_data,char *finalize,char *add_command_line_keyword,char *print_flags) {
  int i_f2py=0;
  f2py_main_def[i_f2py++].data = cpu1;
  f2py_main_def[i_f2py++].data = cputime_used;
  f2py_main_def[i_f2py++].data = walltime_used;
  f2py_main_def[i_f2py++].data = version;
  f2py_main_def[i_f2py++].data = nit_total;
  f2py_main_def[i_f2py++].data = ncheck;
  f2py_main_def[i_f2py++].data = dncheck;
  f2py_main_def[i_f2py++].data = cmd_line_args;
  f2py_main_def[i_f2py++].data = cmd_line_args_count;
  f2py_main_def[i_f2py++].data = run_mfix0;
  f2py_main_def[i_f2py++].data = initialize;
  f2py_main_def[i_f2py++].data = get_data;
  f2py_main_def[i_f2py++].data = check_data;
  f2py_main_def[i_f2py++].data = finalize;
  f2py_main_def[i_f2py++].data = add_command_line_keyword;
  f2py_main_def[i_f2py++].data = print_flags;
}
extern void F_FUNC(f2pyinitmain,F2PYINITMAIN)(void (*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char *,char *,char *,char *,char *,char *,char *));
static void f2py_init_main(void) {
  F_FUNC(f2pyinitmain,F2PYINITMAIN)(f2py_setup_main);
}


static FortranDataDef f2py_parallel_mpi_def[] = {
  {"parallel_init",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_parallel_mpi_parallel_init,doc_f2py_rout_mfixsolver_parallel_mpi_parallel_init},
  {"parallel_fin",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_parallel_mpi_parallel_fin,doc_f2py_rout_mfixsolver_parallel_mpi_parallel_fin},
  {"mpi_check",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_parallel_mpi_mpi_check,doc_f2py_rout_mfixsolver_parallel_mpi_mpi_check},
  {NULL}
};

static void f2py_setup_parallel_mpi(char *parallel_init,char *parallel_fin,char *mpi_check) {
  int i_f2py=0;
  f2py_parallel_mpi_def[i_f2py++].data = parallel_init;
  f2py_parallel_mpi_def[i_f2py++].data = parallel_fin;
  f2py_parallel_mpi_def[i_f2py++].data = mpi_check;
}
extern void F_FUNC_US(f2pyinitparallel_mpi,F2PYINITPARALLEL_MPI)(void (*)(char *,char *,char *));
static void f2py_init_parallel_mpi(void) {
  F_FUNC_US(f2pyinitparallel_mpi,F2PYINITPARALLEL_MPI)(f2py_setup_parallel_mpi);
}


static FortranDataDef f2py_param_def[] = {
  {"dimension_i",0,{{-1}},NPY_INT},
  {"dimension_j",0,{{-1}},NPY_INT},
  {"dimension_k",0,{{-1}},NPY_INT},
  {"dimension_3_alloc",0,{{-1}},NPY_INT},
  {"dimension_3",0,{{-1}},NPY_INT},
  {"dimension_3l",0,{{-1}},NPY_INT},
  {"dimension_3g",0,{{-1}},NPY_INT},
  {"dimension_3p",0,{{-1}},NPY_INT},
  {"dimension_4",0,{{-1}},NPY_INT},
  {"dimension_m",0,{{-1}},NPY_INT},
  {"dimension_n_g",0,{{-1}},NPY_INT},
  {"dimension_n_s",0,{{-1}},NPY_INT},
  {"dimension_scalar",0,{{-1}},NPY_INT},
  {"dim_scalar2",0,{{-1}},NPY_INT},
  {"east",0,{{-1}},NPY_INT},
  {"west",0,{{-1}},NPY_INT},
  {"north",0,{{-1}},NPY_INT},
  {"south",0,{{-1}},NPY_INT},
  {"top",0,{{-1}},NPY_INT},
  {"bottom",0,{{-1}},NPY_INT},
  {"dimension_rxn",0,{{-1}},NPY_INT},
  {"dimension_c",0,{{-1}},NPY_INT},
  {"dimension_ic",0,{{-1}},NPY_INT},
  {"dimension_bc",0,{{-1}},NPY_INT},
  {"dimension_is",0,{{-1}},NPY_INT},
  {"dimension_ps",0,{{-1}},NPY_INT},
  {"dim_m",0,{{-1}},NPY_INT},
  {"dim_n_g",0,{{-1}},NPY_INT},
  {"dim_n_s",0,{{-1}},NPY_INT},
  {"dim_n",0,{{-1}},NPY_INT},
  {"dim_n_all",0,{{-1}},NPY_INT},
  {"dim_i",0,{{-1}},NPY_INT},
  {"dim_j",0,{{-1}},NPY_INT},
  {"dim_k",0,{{-1}},NPY_INT},
  {"dimension_usr",0,{{-1}},NPY_INT},
  {"dim_scalar",0,{{-1}},NPY_INT},
  {"dim_eqs",0,{{-1}},NPY_INT},
  {"filler",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_param_filler,doc_f2py_rout_mfixsolver_param_filler},
  {NULL}
};

static void f2py_setup_param(char *dimension_i,char *dimension_j,char *dimension_k,char *dimension_3_alloc,char *dimension_3,char *dimension_3l,char *dimension_3g,char *dimension_3p,char *dimension_4,char *dimension_m,char *dimension_n_g,char *dimension_n_s,char *dimension_scalar,char *dim_scalar2,char *east,char *west,char *north,char *south,char *top,char *bottom,char *dimension_rxn,char *dimension_c,char *dimension_ic,char *dimension_bc,char *dimension_is,char *dimension_ps,char *dim_m,char *dim_n_g,char *dim_n_s,char *dim_n,char *dim_n_all,char *dim_i,char *dim_j,char *dim_k,char *dimension_usr,char *dim_scalar,char *dim_eqs,char *filler) {
  int i_f2py=0;
  f2py_param_def[i_f2py++].data = dimension_i;
  f2py_param_def[i_f2py++].data = dimension_j;
  f2py_param_def[i_f2py++].data = dimension_k;
  f2py_param_def[i_f2py++].data = dimension_3_alloc;
  f2py_param_def[i_f2py++].data = dimension_3;
  f2py_param_def[i_f2py++].data = dimension_3l;
  f2py_param_def[i_f2py++].data = dimension_3g;
  f2py_param_def[i_f2py++].data = dimension_3p;
  f2py_param_def[i_f2py++].data = dimension_4;
  f2py_param_def[i_f2py++].data = dimension_m;
  f2py_param_def[i_f2py++].data = dimension_n_g;
  f2py_param_def[i_f2py++].data = dimension_n_s;
  f2py_param_def[i_f2py++].data = dimension_scalar;
  f2py_param_def[i_f2py++].data = dim_scalar2;
  f2py_param_def[i_f2py++].data = east;
  f2py_param_def[i_f2py++].data = west;
  f2py_param_def[i_f2py++].data = north;
  f2py_param_def[i_f2py++].data = south;
  f2py_param_def[i_f2py++].data = top;
  f2py_param_def[i_f2py++].data = bottom;
  f2py_param_def[i_f2py++].data = dimension_rxn;
  f2py_param_def[i_f2py++].data = dimension_c;
  f2py_param_def[i_f2py++].data = dimension_ic;
  f2py_param_def[i_f2py++].data = dimension_bc;
  f2py_param_def[i_f2py++].data = dimension_is;
  f2py_param_def[i_f2py++].data = dimension_ps;
  f2py_param_def[i_f2py++].data = dim_m;
  f2py_param_def[i_f2py++].data = dim_n_g;
  f2py_param_def[i_f2py++].data = dim_n_s;
  f2py_param_def[i_f2py++].data = dim_n;
  f2py_param_def[i_f2py++].data = dim_n_all;
  f2py_param_def[i_f2py++].data = dim_i;
  f2py_param_def[i_f2py++].data = dim_j;
  f2py_param_def[i_f2py++].data = dim_k;
  f2py_param_def[i_f2py++].data = dimension_usr;
  f2py_param_def[i_f2py++].data = dim_scalar;
  f2py_param_def[i_f2py++].data = dim_eqs;
  f2py_param_def[i_f2py++].data = filler;
}
extern void F_FUNC(f2pyinitparam,F2PYINITPARAM)(void (*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char *));
static void f2py_init_param(void) {
  F_FUNC(f2pyinitparam,F2PYINITPARAM)(f2py_setup_param);
}


static FortranDataDef f2py_pause_def[] = {
  {"pause_flag",0,{{-1}},NPY_INT},
  {"reinit_flag",0,{{-1}},NPY_INT},
  {"autostart_flag",0,{{-1}},NPY_INT},
  {"ier",0,{{-1}},NPY_INT},
  {"reinit_data",1,{{100000}},NPY_STRING},
  {"wait_while_paused",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_pause_wait_while_paused,doc_f2py_rout_mfixsolver_pause_wait_while_paused},
  {"paused_flag_bcast",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_pause_paused_flag_bcast,doc_f2py_rout_mfixsolver_pause_paused_flag_bcast},
  {"check_reinit_flag",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_pause_check_reinit_flag,doc_f2py_rout_mfixsolver_pause_check_reinit_flag},
  {"set_reinit_data",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_pause_set_reinit_data,doc_f2py_rout_mfixsolver_pause_set_reinit_data},
  {"do_reinit",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_pause_do_reinit,doc_f2py_rout_mfixsolver_pause_do_reinit},
  {"usleep",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_pause_usleep,doc_f2py_rout_mfixsolver_pause_usleep},
  {NULL}
};

static void f2py_setup_pause(char *pause_flag,char *reinit_flag,char *autostart_flag,char *ier,char *reinit_data,char *wait_while_paused,char *paused_flag_bcast,char *check_reinit_flag,char *set_reinit_data,char *do_reinit,char *usleep) {
  int i_f2py=0;
  f2py_pause_def[i_f2py++].data = pause_flag;
  f2py_pause_def[i_f2py++].data = reinit_flag;
  f2py_pause_def[i_f2py++].data = autostart_flag;
  f2py_pause_def[i_f2py++].data = ier;
  f2py_pause_def[i_f2py++].data = reinit_data;
  f2py_pause_def[i_f2py++].data = wait_while_paused;
  f2py_pause_def[i_f2py++].data = paused_flag_bcast;
  f2py_pause_def[i_f2py++].data = check_reinit_flag;
  f2py_pause_def[i_f2py++].data = set_reinit_data;
  f2py_pause_def[i_f2py++].data = do_reinit;
  f2py_pause_def[i_f2py++].data = usleep;
}
extern void F_FUNC(f2pyinitpause,F2PYINITPAUSE)(void (*)(char*,char*,char*,char*,char*,char *,char *,char *,char *,char *,char *));
static void f2py_init_pause(void) {
  F_FUNC(f2pyinitpause,F2PYINITPAUSE)(f2py_setup_pause);
}


static FortranDataDef f2py_residual_pub_def[] = {
  {"group_resid",0,{{-1}},NPY_INT},
  {"get_resid_string_count",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_residual_pub_get_resid_string_count,doc_f2py_rout_mfixsolver_residual_pub_get_resid_string_count},
  {"get_resid_string",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_residual_pub_get_resid_string,doc_f2py_rout_mfixsolver_residual_pub_get_resid_string},
  {"get_resid_grp_string_count",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_residual_pub_get_resid_grp_string_count,doc_f2py_rout_mfixsolver_residual_pub_get_resid_grp_string_count},
  {"get_resid_grp_string",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_residual_pub_get_resid_grp_string,doc_f2py_rout_mfixsolver_residual_pub_get_resid_grp_string},
  {"get_resid",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_residual_pub_get_resid,doc_f2py_rout_mfixsolver_residual_pub_get_resid},
  {"get_resid_grp",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_residual_pub_get_resid_grp,doc_f2py_rout_mfixsolver_residual_pub_get_resid_grp},
  {NULL}
};

static void f2py_setup_residual_pub(char *group_resid,char *get_resid_string_count,char *get_resid_string,char *get_resid_grp_string_count,char *get_resid_grp_string,char *get_resid,char *get_resid_grp) {
  int i_f2py=0;
  f2py_residual_pub_def[i_f2py++].data = group_resid;
  f2py_residual_pub_def[i_f2py++].data = get_resid_string_count;
  f2py_residual_pub_def[i_f2py++].data = get_resid_string;
  f2py_residual_pub_def[i_f2py++].data = get_resid_grp_string_count;
  f2py_residual_pub_def[i_f2py++].data = get_resid_grp_string;
  f2py_residual_pub_def[i_f2py++].data = get_resid;
  f2py_residual_pub_def[i_f2py++].data = get_resid_grp;
}
extern void F_FUNC_US(f2pyinitresidual_pub,F2PYINITRESIDUAL_PUB)(void (*)(char*,char *,char *,char *,char *,char *,char *));
static void f2py_init_residual_pub(void) {
  F_FUNC_US(f2pyinitresidual_pub,F2PYINITRESIDUAL_PUB)(f2py_setup_residual_pub);
}


static FortranDataDef f2py_run_def[] = {
  {"run_name",1,{{60}},NPY_STRING},
  {"description",1,{{60}},NPY_STRING},
  {"units",1,{{16}},NPY_STRING},
  {"run_type",1,{{16}},NPY_STRING},
  {"automatic_restart",0,{{-1}},NPY_INT},
  {"iter_restart",0,{{-1}},NPY_INT},
  {"id_version",1,{{10}},NPY_STRING},
  {"time",0,{{-1}},NPY_DOUBLE},
  {"tstop",0,{{-1}},NPY_DOUBLE},
  {"dt",0,{{-1}},NPY_DOUBLE},
  {"odt",0,{{-1}},NPY_DOUBLE},
  {"steady_state",0,{{-1}},NPY_INT},
  {"nstep",0,{{-1}},NPY_INT},
  {"nsteprst",0,{{-1}},NPY_INT},
  {"discretize",1,{{10}},NPY_INT},
  {"chi_scheme",0,{{-1}},NPY_INT},
  {"momentum_x_eq",1,{{11}},NPY_INT},
  {"momentum_y_eq",1,{{11}},NPY_INT},
  {"momentum_z_eq",1,{{11}},NPY_INT},
  {"jackson",0,{{-1}},NPY_INT},
  {"ishii",0,{{-1}},NPY_INT},
  {"model_b",0,{{-1}},NPY_INT},
  {"added_mass",0,{{-1}},NPY_INT},
  {"m_am",0,{{-1}},NPY_INT},
  {"energy_eq",0,{{-1}},NPY_INT},
  {"def_cor",0,{{-1}},NPY_INT},
  {"cn_on",0,{{-1}},NPY_INT},
  {"granular_energy",0,{{-1}},NPY_INT},
  {"species_eq",1,{{11}},NPY_INT},
  {"any_species_eq",0,{{-1}},NPY_INT},
  {"call_usr",0,{{-1}},NPY_INT},
  {"persistent_mode",0,{{-1}},NPY_INT},
  {"call_dqmom",0,{{-1}},NPY_INT},
  {"subgrid_wall",0,{{-1}},NPY_INT},
  {"filter_size_ratio",0,{{-1}},NPY_DOUBLE},
  {"cd_function",1,{{64}},NPY_STRING},
  {"lam_hys",0,{{-1}},NPY_DOUBLE},
  {"simonin",0,{{-1}},NPY_INT},
  {"ahmadi",0,{{-1}},NPY_INT},
  {"friction_model",1,{{64}},NPY_STRING},
  {"schaeffer",0,{{-1}},NPY_INT},
  {"friction",0,{{-1}},NPY_INT},
  {"savage",0,{{-1}},NPY_INT},
  {"blending_function",1,{{64}},NPY_STRING},
  {"blending_stress",0,{{-1}},NPY_INT},
  {"tanh_blend",0,{{-1}},NPY_INT},
  {"sigm_blend",0,{{-1}},NPY_INT},
  {"jenkins",0,{{-1}},NPY_INT},
  {"bc_jj_m",0,{{-1}},NPY_INT},
  {"phip_out_jj",0,{{-1}},NPY_INT},
  {"phip_out_iter",0,{{-1}},NPY_INT},
  {"shear",0,{{-1}},NPY_INT},
  {"v_sh",0,{{-1}},NPY_DOUBLE},
  {"yu_standish",0,{{-1}},NPY_INT},
  {"fedors_landel",0,{{-1}},NPY_INT},
  {"chk_batchq_end",0,{{-1}},NPY_INT},
  {"batch_wallclock",0,{{-1}},NPY_DOUBLE},
  {"term_buffer",0,{{-1}},NPY_DOUBLE},
  {"auto_restart",0,{{-1}},NPY_INT},
  {"reinitializing",0,{{-1}},NPY_INT},
  {"timestep_fail_rate",1,{{2}},NPY_INT},
  {"dt_dir",0,{{-1}},NPY_INT},
  {"dt_max",0,{{-1}},NPY_DOUBLE},
  {"dt_min",0,{{-1}},NPY_DOUBLE},
  {"dt_fac",0,{{-1}},NPY_DOUBLE},
  {"dt_prev",0,{{-1}},NPY_DOUBLE},
  {"use_dt_prev",0,{{-1}},NPY_INT},
  {"detect_stall",0,{{-1}},NPY_INT},
  {"debug_resid",0,{{-1}},NPY_INT},
  {"solve_ros",1,{{10}},NPY_INT},
  {"any_solve_ros",0,{{-1}},NPY_INT},
  {"solids_model",1,{{10,3}},NPY_STRING},
  {"discrete_element",0,{{-1}},NPY_INT},
  {"des_continuum_coupled",0,{{-1}},NPY_INT},
  {"tfm_solids",0,{{-1}},NPY_INT},
  {"dem_solids",0,{{-1}},NPY_INT},
  {"pic_solids",0,{{-1}},NPY_INT},
  {"tfm_count",0,{{-1}},NPY_INT},
  {"dem_count",0,{{-1}},NPY_INT},
  {"pic_count",0,{{-1}},NPY_INT},
  {"ier",0,{{-1}},NPY_INT},
  {"tunit",1,{{4}},NPY_STRING},
  {"ppo",0,{{-1}},NPY_INT},
  {"optflag1",0,{{-1}},NPY_INT},
  {"get_tunit",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_run_get_tunit,doc_f2py_rout_mfixsolver_run_get_tunit},
  {NULL}
};

static void f2py_setup_run(char *run_name,char *description,char *units,char *run_type,char *automatic_restart,char *iter_restart,char *id_version,char *time,char *tstop,char *dt,char *odt,char *steady_state,char *nstep,char *nsteprst,char *discretize,char *chi_scheme,char *momentum_x_eq,char *momentum_y_eq,char *momentum_z_eq,char *jackson,char *ishii,char *model_b,char *added_mass,char *m_am,char *energy_eq,char *def_cor,char *cn_on,char *granular_energy,char *species_eq,char *any_species_eq,char *call_usr,char *persistent_mode,char *call_dqmom,char *subgrid_wall,char *filter_size_ratio,char *cd_function,char *lam_hys,char *simonin,char *ahmadi,char *friction_model,char *schaeffer,char *friction,char *savage,char *blending_function,char *blending_stress,char *tanh_blend,char *sigm_blend,char *jenkins,char *bc_jj_m,char *phip_out_jj,char *phip_out_iter,char *shear,char *v_sh,char *yu_standish,char *fedors_landel,char *chk_batchq_end,char *batch_wallclock,char *term_buffer,char *auto_restart,char *reinitializing,char *timestep_fail_rate,char *dt_dir,char *dt_max,char *dt_min,char *dt_fac,char *dt_prev,char *use_dt_prev,char *detect_stall,char *debug_resid,char *solve_ros,char *any_solve_ros,char *solids_model,char *discrete_element,char *des_continuum_coupled,char *tfm_solids,char *dem_solids,char *pic_solids,char *tfm_count,char *dem_count,char *pic_count,char *ier,char *tunit,char *ppo,char *optflag1,char *get_tunit) {
  int i_f2py=0;
  f2py_run_def[i_f2py++].data = run_name;
  f2py_run_def[i_f2py++].data = description;
  f2py_run_def[i_f2py++].data = units;
  f2py_run_def[i_f2py++].data = run_type;
  f2py_run_def[i_f2py++].data = automatic_restart;
  f2py_run_def[i_f2py++].data = iter_restart;
  f2py_run_def[i_f2py++].data = id_version;
  f2py_run_def[i_f2py++].data = time;
  f2py_run_def[i_f2py++].data = tstop;
  f2py_run_def[i_f2py++].data = dt;
  f2py_run_def[i_f2py++].data = odt;
  f2py_run_def[i_f2py++].data = steady_state;
  f2py_run_def[i_f2py++].data = nstep;
  f2py_run_def[i_f2py++].data = nsteprst;
  f2py_run_def[i_f2py++].data = discretize;
  f2py_run_def[i_f2py++].data = chi_scheme;
  f2py_run_def[i_f2py++].data = momentum_x_eq;
  f2py_run_def[i_f2py++].data = momentum_y_eq;
  f2py_run_def[i_f2py++].data = momentum_z_eq;
  f2py_run_def[i_f2py++].data = jackson;
  f2py_run_def[i_f2py++].data = ishii;
  f2py_run_def[i_f2py++].data = model_b;
  f2py_run_def[i_f2py++].data = added_mass;
  f2py_run_def[i_f2py++].data = m_am;
  f2py_run_def[i_f2py++].data = energy_eq;
  f2py_run_def[i_f2py++].data = def_cor;
  f2py_run_def[i_f2py++].data = cn_on;
  f2py_run_def[i_f2py++].data = granular_energy;
  f2py_run_def[i_f2py++].data = species_eq;
  f2py_run_def[i_f2py++].data = any_species_eq;
  f2py_run_def[i_f2py++].data = call_usr;
  f2py_run_def[i_f2py++].data = persistent_mode;
  f2py_run_def[i_f2py++].data = call_dqmom;
  f2py_run_def[i_f2py++].data = subgrid_wall;
  f2py_run_def[i_f2py++].data = filter_size_ratio;
  f2py_run_def[i_f2py++].data = cd_function;
  f2py_run_def[i_f2py++].data = lam_hys;
  f2py_run_def[i_f2py++].data = simonin;
  f2py_run_def[i_f2py++].data = ahmadi;
  f2py_run_def[i_f2py++].data = friction_model;
  f2py_run_def[i_f2py++].data = schaeffer;
  f2py_run_def[i_f2py++].data = friction;
  f2py_run_def[i_f2py++].data = savage;
  f2py_run_def[i_f2py++].data = blending_function;
  f2py_run_def[i_f2py++].data = blending_stress;
  f2py_run_def[i_f2py++].data = tanh_blend;
  f2py_run_def[i_f2py++].data = sigm_blend;
  f2py_run_def[i_f2py++].data = jenkins;
  f2py_run_def[i_f2py++].data = bc_jj_m;
  f2py_run_def[i_f2py++].data = phip_out_jj;
  f2py_run_def[i_f2py++].data = phip_out_iter;
  f2py_run_def[i_f2py++].data = shear;
  f2py_run_def[i_f2py++].data = v_sh;
  f2py_run_def[i_f2py++].data = yu_standish;
  f2py_run_def[i_f2py++].data = fedors_landel;
  f2py_run_def[i_f2py++].data = chk_batchq_end;
  f2py_run_def[i_f2py++].data = batch_wallclock;
  f2py_run_def[i_f2py++].data = term_buffer;
  f2py_run_def[i_f2py++].data = auto_restart;
  f2py_run_def[i_f2py++].data = reinitializing;
  f2py_run_def[i_f2py++].data = timestep_fail_rate;
  f2py_run_def[i_f2py++].data = dt_dir;
  f2py_run_def[i_f2py++].data = dt_max;
  f2py_run_def[i_f2py++].data = dt_min;
  f2py_run_def[i_f2py++].data = dt_fac;
  f2py_run_def[i_f2py++].data = dt_prev;
  f2py_run_def[i_f2py++].data = use_dt_prev;
  f2py_run_def[i_f2py++].data = detect_stall;
  f2py_run_def[i_f2py++].data = debug_resid;
  f2py_run_def[i_f2py++].data = solve_ros;
  f2py_run_def[i_f2py++].data = any_solve_ros;
  f2py_run_def[i_f2py++].data = solids_model;
  f2py_run_def[i_f2py++].data = discrete_element;
  f2py_run_def[i_f2py++].data = des_continuum_coupled;
  f2py_run_def[i_f2py++].data = tfm_solids;
  f2py_run_def[i_f2py++].data = dem_solids;
  f2py_run_def[i_f2py++].data = pic_solids;
  f2py_run_def[i_f2py++].data = tfm_count;
  f2py_run_def[i_f2py++].data = dem_count;
  f2py_run_def[i_f2py++].data = pic_count;
  f2py_run_def[i_f2py++].data = ier;
  f2py_run_def[i_f2py++].data = tunit;
  f2py_run_def[i_f2py++].data = ppo;
  f2py_run_def[i_f2py++].data = optflag1;
  f2py_run_def[i_f2py++].data = get_tunit;
}
extern void F_FUNC(f2pyinitrun,F2PYINITRUN)(void (*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char *));
static void f2py_init_run(void) {
  F_FUNC(f2pyinitrun,F2PYINITRUN)(f2py_setup_run);
}


static FortranDataDef f2py_time_cpu_def[] = {
  {"cpuos",0,{{-1}},NPY_DOUBLE},
  {"cpu_nlog",0,{{-1}},NPY_DOUBLE},
  {"time_nlog",0,{{-1}},NPY_DOUBLE},
  {"cpu0",0,{{-1}},NPY_DOUBLE},
  {"cpu_io",0,{{-1}},NPY_DOUBLE},
  {"cpu00",0,{{-1}},NPY_DOUBLE},
  {"wall0",0,{{-1}},NPY_DOUBLE},
  {"time_start",0,{{-1}},NPY_DOUBLE},
  {"wall_start",0,{{-1}},NPY_DOUBLE},
  {"wall_pause_start",0,{{-1}},NPY_DOUBLE},
  {"wall_paused",0,{{-1}},NPY_DOUBLE},
  {"wall_time",-1,{{-1}},0,NULL,(void *)f2py_rout_mfixsolver_time_cpu_wall_time,doc_f2py_rout_mfixsolver_time_cpu_wall_time},
  {NULL}
};

static void f2py_setup_time_cpu(char *cpuos,char *cpu_nlog,char *time_nlog,char *cpu0,char *cpu_io,char *cpu00,char *wall0,char *time_start,char *wall_start,char *wall_pause_start,char *wall_paused,char *wall_time) {
  int i_f2py=0;
  f2py_time_cpu_def[i_f2py++].data = cpuos;
  f2py_time_cpu_def[i_f2py++].data = cpu_nlog;
  f2py_time_cpu_def[i_f2py++].data = time_nlog;
  f2py_time_cpu_def[i_f2py++].data = cpu0;
  f2py_time_cpu_def[i_f2py++].data = cpu_io;
  f2py_time_cpu_def[i_f2py++].data = cpu00;
  f2py_time_cpu_def[i_f2py++].data = wall0;
  f2py_time_cpu_def[i_f2py++].data = time_start;
  f2py_time_cpu_def[i_f2py++].data = wall_start;
  f2py_time_cpu_def[i_f2py++].data = wall_pause_start;
  f2py_time_cpu_def[i_f2py++].data = wall_paused;
  f2py_time_cpu_def[i_f2py++].data = wall_time;
}
extern void F_FUNC_US(f2pyinittime_cpu,F2PYINITTIME_CPU)(void (*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char *));
static void f2py_init_time_cpu(void) {
  F_FUNC_US(f2pyinittime_cpu,F2PYINITTIME_CPU)(f2py_setup_time_cpu);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_run_dp_def[] = {
  {"time",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_run_dp(char *time) {
  int i_f2py=0;
  f2py_run_dp_def[i_f2py++].data = time;
}
extern void F_FUNC_US(f2pyinitrun_dp,F2PYINITRUN_DP)(void(*)(char*));
static void f2py_init_run_dp(void) {
  F_FUNC_US(f2pyinitrun_dp,F2PYINITRUN_DP)(f2py_setup_run_dp);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "mfixsolver",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyMODINIT_FUNC PyInit_mfixsolver(void) {
#else
#define RETVAL
PyMODINIT_FUNC initmfixsolver(void) {
#endif
  int i;
  PyObject *m,*d, *s;
#if PY_VERSION_HEX >= 0x03000000
  m = mfixsolver_module = PyModule_Create(&moduledef);
#else
  m = mfixsolver_module = Py_InitModule("mfixsolver", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module mfixsolver (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module 'mfixsolver' is auto-generated with f2py (version:2).\nFunctions:\n"
"COMMON blocks:\n""  /run_dp/ time\n""Fortran 90/95 modules:\n""  compar --- mype,numpes,mpierr,pe_io,nodesi,nodesj,nodesk,dlb_nodesi,dlb_nodesj,dlb_nodesk,root,nlayers_bicgs,ijkstart3_all,ijkend3_all,istart_all,istart1_all,istart2_all,istart3_all,jstart_all,jstart1_all,jstart2_all,jstart3_all,kstart_all,kstart1_all,kstart2_all,kstart3_all,iend_all,iend1_all,iend2_all,iend3_all,jend_all,jend1_all,jend2_all,jend3_all,kend_all,kend1_all,kend2_all,kend3_all,ijksize3_all,displs,imap,jmap,kmap,imap_c,jmap_c,kmap_c,ijksize3,ijkstart3,ijkend3,istart3,iend3,jstart3,jend3,kstart3,kend3,istart2,iend2,jstart2,jend2,kstart2,kend2,istart1,iend1,jstart1,jend1,kstart1,kend1,istart,iend,jstart,jend,kstart,kend,fbname,idbg,c0,c1,c2,ijk_array_of,funijk_map_c,west_array_of,east_array_of,south_array_of,north_array_of,bottom_array_of,top_array_of,im_array_of,ip_array_of,jm_array_of,jp_array_of,km_array_of,kp_array_of,dead_cell_at,increment_arrays_allocated,ngc_east,ngc_west,ngc_north,ngc_south,ngc_top,ngc_bottom,lgc_east,lgc_west,lgc_north,lgc_south,lgc_top,lgc_bottom,isize_all,jsize_all,ksize_all,domain_size_adjusted,ncpp_uniform,ncpp_uniform_backed_up,new_ijksize3_all,short_gridmap_init,adjust_partition""  exit --- exit_flag,mfix_exit(),check_exit_flag(),close_file()""  iterate --- mustit,nit,max_nit,converged,diverged,tleft,normg,norms,setg,sets,resg,ress,smass,errorpercent,lmsg,call_solve_pp_g,iterate_init(),do_iteration(),post_iterate(),log_diverged(),log_converged(),goalseekmassflux(),adjustdt()""  machine --- open_n1,nwords_dp,nwords_r,nwords_i,id_node,id_month,id_day,id_year,id_hour,id_minute,id_second,get_run_id(),start_log(),end_log()""  main --- cpu1,cputime_used,walltime_used,version,nit_total,ncheck,dncheck,cmd_line_args,cmd_line_args_count,run_mfix0(),initialize(),get_data(),check_data(),finalize(),add_command_line_keyword(),print_flags()""  parallel_mpi --- parallel_init(),parallel_fin(),mpi_check()""  param --- dimension_i,dimension_j,dimension_k,dimension_3_alloc,dimension_3,dimension_3l,dimension_3g,dimension_3p,dimension_4,dimension_m,dimension_n_g,dimension_n_s,dimension_scalar,dim_scalar2,east,west,north,south,top,bottom,dimension_rxn,dimension_c,dimension_ic,dimension_bc,dimension_is,dimension_ps,dim_m,dim_n_g,dim_n_s,dim_n,dim_n_all,dim_i,dim_j,dim_k,dimension_usr,dim_scalar,dim_eqs,filler()""  pause --- pause_flag,reinit_flag,autostart_flag,ier,reinit_data,wait_while_paused(),paused_flag_bcast(),check_reinit_flag(),set_reinit_data(),do_reinit(),usleep()""  residual_pub --- group_resid,get_resid_string_count(),get_resid_string(),get_resid_grp_string_count(),get_resid_grp_string(),get_resid(),get_resid_grp()""  run --- run_name,description,units,run_type,automatic_restart,iter_restart,id_version,time,tstop,dt,odt,steady_state,nstep,nsteprst,discretize,chi_scheme,momentum_x_eq,momentum_y_eq,momentum_z_eq,jackson,ishii,model_b,added_mass,m_am,energy_eq,def_cor,cn_on,granular_energy,species_eq,any_species_eq,call_usr,persistent_mode,call_dqmom,subgrid_wall,filter_size_ratio,cd_function,lam_hys,simonin,ahmadi,friction_model,schaeffer,friction,savage,blending_function,blending_stress,tanh_blend,sigm_blend,jenkins,bc_jj_m,phip_out_jj,phip_out_iter,shear,v_sh,yu_standish,fedors_landel,chk_batchq_end,batch_wallclock,term_buffer,auto_restart,reinitializing,timestep_fail_rate,dt_dir,dt_max,dt_min,dt_fac,dt_prev,use_dt_prev,detect_stall,debug_resid,solve_ros,any_solve_ros,solids_model,discrete_element,des_continuum_coupled,tfm_solids,dem_solids,pic_solids,tfm_count,dem_count,pic_count,ier,tunit,ppo,optflag1,get_tunit()""  time_cpu --- cpuos,cpu_nlog,time_nlog,cpu0,cpu_io,cpu00,wall0,time_start,wall_start,wall_pause_start,wall_paused,wall_time()"".");
  PyDict_SetItemString(d, "__doc__", s);
  mfixsolver_error = PyErr_NewException ("mfixsolver.error", NULL, NULL);
  Py_DECREF(s);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++)
    PyDict_SetItemString(d, f2py_routine_defs[i].name,PyFortranObject_NewAsAttr(&f2py_routine_defs[i]));






































/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "time_cpu", PyFortranObject_New(f2py_time_cpu_def,f2py_init_time_cpu));
  PyDict_SetItemString(d, "run", PyFortranObject_New(f2py_run_def,f2py_init_run));
  PyDict_SetItemString(d, "residual_pub", PyFortranObject_New(f2py_residual_pub_def,f2py_init_residual_pub));
  PyDict_SetItemString(d, "pause", PyFortranObject_New(f2py_pause_def,f2py_init_pause));
  PyDict_SetItemString(d, "param", PyFortranObject_New(f2py_param_def,f2py_init_param));
  PyDict_SetItemString(d, "parallel_mpi", PyFortranObject_New(f2py_parallel_mpi_def,f2py_init_parallel_mpi));
  PyDict_SetItemString(d, "main", PyFortranObject_New(f2py_main_def,f2py_init_main));
  PyDict_SetItemString(d, "machine", PyFortranObject_New(f2py_machine_def,f2py_init_machine));
  PyDict_SetItemString(d, "iterate", PyFortranObject_New(f2py_iterate_def,f2py_init_iterate));
  PyDict_SetItemString(d, "exit", PyFortranObject_New(f2py_exit_def,f2py_init_exit));
  PyDict_SetItemString(d, "compar", PyFortranObject_New(f2py_compar_def,f2py_init_compar));
/*eof initf90modhooks*/

  F2PyDict_SetItemString(d, "run_dp", PyFortranObject_New(f2py_run_dp_def,f2py_init_run_dp));
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"mfixsolver");
#endif

  return RETVAL;
}
#ifdef __cplusplus
}
#endif
