      MODULE time_cpu

! cpu time/second
      DOUBLE PRECISION :: CPUos
! old cpu time and time for calculating CPUos
      DOUBLE PRECISION :: CPU_NLOG, TIME_NLOG
! Initial value of CPU time.
      DOUBLE PRECISION :: CPU0
! Time for IO
      DOUBLE PRECISION :: CPU_IO = 0.0d0

! Initial value of CPU time at the begin of MFIX, prior any I/O
      DOUBLE PRECISION :: CPU00
      DOUBLE PRECISION :: WALL0

! Time at start of simulation
      DOUBLE PRECISION :: TIME_START
! Wall time at the beginning
      DOUBLE PRECISION :: WALL_START

! Wall time at the most recent pause
      DOUBLE PRECISION :: WALL_PAUSE_START

! Total wall time spent in PAUSED state
      DOUBLE PRECISION :: WALL_PAUSED = 0.0d0

   contains

!vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvC
!                                                                      C
!  Function name: WALL_TIME (CPU)                                      C
!  Purpose: returns current wall time in seconds                       C
!                                                                      C
!  Author: P. Nicoletti                               Date: 10-JAN-92  C
!  Reviewer: P. Nicoletti, W. Rogers, M. Syamlal      Date:            C
!                                                                      C
!  Revision Number:                                                    C
!  Purpose:                                                            C
!  Author:                                            Date: dd-mmm-yy  C
!  Reviewer:                                          Date: dd-mmm-yy  C
!                                                                      C
!  Literature/Document References:                                     C
!                                                                      C
!  Variables referenced: None                                          C
!  Variables modified: None                                            C
!                                                                      C
!  Local variables: TA, XT                                             C
!                                                                      C
!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^C
!
      double precision function wall_time()

      implicit none

      double precision time

! The absolute value of cpu_time() is meaningless; only offsets should be used
      call cpu_time(time)
      wall_time = time

      end function wall_time

      end module time_cpu
